/**
 * Notice that this store does not have a proxy defined. If you look at the associated model, it does.
 * I usually put the proxy on the model in case I ever wanted to load a single instance of that model
 * using model.load(id, {})
 *
 * If you specify a proxy on the store and proxy, the one on the store will be used.
 */
Ext.define('Photoalbum.store.Images', {
	extend : 'Ext.data.Store',
	xtype: 'photoalbum-imagestore',

   	model : 'Photoalbum.model.Image',
   	autoLoad : false,
   	
   	getPriority: function(record) {
   		if(Ext.getClassName(record)!='Photoalbum.model.Image') return false;
   		var total = 0; 
   		this.each(function(rec) {
   			total += rec.get('clicks');
   		});
   		var clicks = record.get('clicks');
   		return parseFloat(clicks / (total+10)); //few clicks are leveled out ... 5/5=1/3 prio;,10/10=0.5 prio
   	}
});